/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangeException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MyCustomException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithExchangeExceptionAnnotationTest
extends ContextTestSupport {
    public void testBeanWithAnnotationAndExchangeTest() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        MockEndpoint error = this.getMockEndpoint("mock:error");
        result.expectedMessageCount(0);
        error.expectedMessageCount(1);
        error.expectedBodiesReceived(new Object[]{"The Body"});
        this.template.requestBody("direct:start", (Object)"The Body");
        result.assertIsSatisfied();
        error.assertIsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                ((OnExceptionDefinition)this.onException(MyCustomException.class).maximumRedeliveries(0).handled(true).beanRef("myBean", "handleException")).to("mock:error");
                ((RouteDefinition)this.from("direct:start").beanRef("myBean", "throwException")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public void throwException() throws MyCustomException {
            throw new MyCustomException("I'm being thrown!!");
        }

        public void handleException(@ExchangeException Exception exception) {
            TestCase.assertNotNull((Object)exception);
            TestCase.assertEquals((String)"I'm being thrown!!", (String)exception.getMessage());
        }
    }
}

