/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.Simple;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithExpressionInjectionPredicateTest
extends ContextTestSupport {
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        this.template.sendBody("direct:in", (Object)"Hello");
        BeanWithExpressionInjectionPredicateTest.assertEquals((String)"Hello", (String)this.myBean.body);
        BeanWithExpressionInjectionPredicateTest.assertEquals((boolean)false, (boolean)this.myBean.foo);
    }

    public void testSendMessageWithFoo() throws Exception {
        this.template.sendBodyAndHeader("direct:in", (Object)"Hello", "foo", (Object)123);
        BeanWithExpressionInjectionPredicateTest.assertEquals((String)"Hello", (String)this.myBean.body);
        BeanWithExpressionInjectionPredicateTest.assertEquals((boolean)true, (boolean)this.myBean.foo);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
            }
        };
    }

    public static class MyBean {
        public String body;
        public boolean foo;

        public void read(String body, @Simple(value="${header.foo} != null") boolean foo) {
            this.body = body;
            this.foo = foo;
        }
    }
}

