/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithHeadersAndBodyInject2Test
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanWithHeadersAndBodyInject2Test.class);
    private MyBean myBean = new MyBean();
    private Map<String, User> users = new HashMap<String, User>();

    public void testCannotBindToParameter() throws Exception {
        this.users.put("charles", new User("Charles", "43"));
        this.users.put("claus", new User("Claus", "33"));
        Exchange out = this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("p1", (Object)"abc");
                exchange.setProperty("p2", (Object)123);
                Message in = exchange.getIn();
                in.setHeader("users", (Object)BeanWithHeadersAndBodyInject2Test.this.users);
                in.setBody((Object)"TheBody");
            }
        });
        BeanWithHeadersAndBodyInject2Test.assertTrue((String)"Should fail", (boolean)out.isFailed());
        BeanWithHeadersAndBodyInject2Test.assertIsInstanceOf(RuntimeCamelException.class, out.getException());
        BeanWithHeadersAndBodyInject2Test.assertIsInstanceOf(NoTypeConversionAvailableException.class, out.getException().getCause());
    }

    public void testBindToParameter() throws Exception {
        final ArrayList<String> list = new ArrayList<String>();
        list.add("Charles");
        list.add("Claus");
        Exchange out = this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"TheBody");
                exchange.getIn().setHeader("users", (Object)list);
            }
        });
        BeanWithHeadersAndBodyInject2Test.assertFalse((String)"Should not fail", (boolean)out.isFailed());
        BeanWithHeadersAndBodyInject2Test.assertSame(list, this.myBean.users);
        BeanWithHeadersAndBodyInject2Test.assertEquals((Object)"TheBody", (Object)this.myBean.body);
    }

    public void testBindToParameterIsNullValue() throws Exception {
        Exchange out = this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"TheBody");
                exchange.getIn().setHeader("users", null);
            }
        });
        BeanWithHeadersAndBodyInject2Test.assertFalse((String)"Should not fail", (boolean)out.isFailed());
        BeanWithHeadersAndBodyInject2Test.assertEquals((Object)"TheBody", (Object)this.myBean.body);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").to("bean:myBean?method=myMethod");
            }
        };
    }

    public static class User {
        public String name;
        public String age;

        public User(String name, String age) {
            this.name = name;
            this.age = age;
        }
    }

    public static class MyBean {
        public Object body;
        public List<User> users;

        public void myMethod(@Header(value="users") List<User> users, Object body) {
            LOG.info("myMethod() method called on " + this);
            LOG.info(" users " + users);
            this.body = body;
            this.users = users;
        }
    }
}

