/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BridgeMethodTest
extends ContextTestSupport {
    public void testBridgeMethod() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:bar").message(0).body()).isEqualTo((Object)new MyMessageClass(4));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        jndi.bind("bar", (Object)new MyBarBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("bean:foo").to("bean:bar")).to("mock:bar");
            }
        };
    }

    private static class MyBarBean
    implements MyBar<MessageBaseClass> {
        private MyBarBean() {
        }

        @Override
        public MessageBaseClass function(MessageBaseClass arg) {
            return arg.doubleIt();
        }
    }

    private static interface MyBar<T> {
        public T function(T var1);
    }

    private static class MyFooBean {
        private MyFooBean() {
        }

        public MyMessageClass source() {
            return new MyMessageClass(2);
        }
    }

    private static class MyMessageClass
    extends MessageBaseClass {
        public MyMessageClass(int i) {
            super(i);
        }

        @Override
        public MyMessageClass doubleIt() {
            return new MyMessageClass(2 * this.i);
        }
    }

    private static class MessageBaseClass {
        final int i;

        public MessageBaseClass(int i) {
            this.i = i;
        }

        public MessageBaseClass doubleIt() {
            return new MessageBaseClass(2 * this.i);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return ((MessageBaseClass)o).i == this.i;
        }

        public int hashCode() {
            return 0;
        }
    }
}

