/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Registry;

public final class CamelSimpleExpressionPerfTestRunner {
    private static final int MESSAGE_LOOP_COUNT = 1000;
    private static final int TEST_EXECUTION_COUNT = 5;

    private CamelSimpleExpressionPerfTestRunner() {
    }

    public static void main(String[] args) throws Exception {
        long bodyOnly = CamelSimpleExpressionPerfTestRunner.executePerformanceTest((Registry)new SimpleRegistry(), "${body}");
        long bodyProperty = CamelSimpleExpressionPerfTestRunner.executePerformanceTest((Registry)new SimpleRegistry(), "${body[p]}");
        long bodyPropertyWithCache = CamelSimpleExpressionPerfTestRunner.executePerformanceTest((Registry)new SimpleRegistry(), "${body[p]}");
        System.out.printf("${body}: %dms%n", bodyOnly);
        System.out.printf("${body[p]} : %dms%n", bodyProperty);
        System.out.printf("${body[p]} with cache : %dms%n", bodyPropertyWithCache);
    }

    private static long executePerformanceTest(Registry registry, final String simpleExpression) throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext(registry);
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)this.from("direct:start").loop(1000).setHeader("test").simple(simpleExpression)).to("mock:plop");
            }
        });
        ctx.start();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("p", "q");
        ProducerTemplate template = ctx.createProducerTemplate();
        template.sendBody("direct:start", body);
        long totalNsDuration = 0L;
        for (int i = 0; i < 5; ++i) {
            long tick = System.nanoTime();
            template.sendBody("direct:start", body);
            totalNsDuration += System.nanoTime() - tick;
        }
        ctx.stop();
        return totalNsDuration / 5L / 1000L / 1000L;
    }
}

