/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.impl.JndiRegistry;

public class FromBeanTest
extends ContextTestSupport {
    public void testFromBean() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:bar").message(0).body()).isEqualTo((Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("bean:foo?method=hello").to("mock:bar");
            }
        };
    }

    private static class MyFooBean {
        private MyFooBean() {
        }

        public String hello() {
            return "Hello";
        }

        public String bye() {
            return "Bye";
        }
    }
}

