/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;

public class ProxyReturnFutureTest
extends ContextTestSupport {
    public void testFutureEcho() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Future<String> future = service.asText(4);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        String reply = future.get(5L, TimeUnit.SECONDS);
        ProxyReturnFutureTest.assertEquals((String)"Four", (String)reply);
    }

    public void testFutureEchoCallTwoTimes() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Future<String> future = service.asText(4);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        ProxyReturnFutureTest.assertEquals((String)"Four", (String)future.get(5L, TimeUnit.SECONDS));
        future = service.asText(5);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        ProxyReturnFutureTest.assertEquals((String)"Four", (String)future.get(5L, TimeUnit.SECONDS));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:echo").delay(250L).transform().constant((Object)"Four");
            }
        };
    }

    public static interface Echo {
        public Future<String> asText(int var1);
    }
}

