/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.pojomessage;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.PojoProxyHelper;
import org.apache.camel.component.bean.pojomessage.Person;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class PojoProxyHelperOneWayTest
extends ContextTestSupport {
    PersonReceiver receiver = new PersonReceiver();

    @Test
    public void testOneWay() throws Exception {
        Endpoint personEndpoint = this.context.getEndpoint("direct:person");
        MockEndpoint result = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        Person person = new Person("Chris");
        result.expectedBodiesReceived(new Object[]{person});
        PersonHandler sender = (PersonHandler)PojoProxyHelper.createProxy((Endpoint)personEndpoint, (Class[])new Class[]{PersonHandler.class});
        sender.onPerson(person);
        result.assertIsSatisfied();
        PojoProxyHelperOneWayTest.assertEquals((int)1, (int)this.receiver.receivedPersons.size());
        PojoProxyHelperOneWayTest.assertEquals((String)person.getName(), (String)this.receiver.receivedPersons.get(0).getName());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:person").to("mock:result")).bean((Object)PojoProxyHelperOneWayTest.this.receiver);
            }
        };
    }

    public static interface PersonHandler {
        public void onPerson(Person var1);
    }

    public final class PersonReceiver
    implements PersonHandler {
        public List<Person> receivedPersons = new ArrayList<Person>();

        @Override
        public void onPerson(Person person) {
            this.receivedPersons.add(person);
        }
    }
}

