/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.dataformat.DataFormatComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class DataFormatComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DataFormatComponent comp = (DataFormatComponent)this.context.getComponent("dataformat", DataFormatComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("dataformaat:marshal:string?charset=iso-8859-1");
        DataFormatComponentConfigurationAndDocumentationTest.assertEquals((Object)"iso-8859-1", (Object)conf.getParameter("charset"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"operation\": { \"type\": \"java.lang.String\" }"));
        DataFormatComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"synchronous\": { \"type\": \"boolean\" }"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        if (DataFormatComponentConfigurationAndDocumentationTest.isJavaVersion("1.6")) {
            return;
        }
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("dataformat");
        DataFormatComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML if on Java 7", (Object)html);
    }
}

