/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.MySerialBean;

public class DataFormatEndpointSerializationTest
extends ContextTestSupport {
    public void testSerialization() throws Exception {
        MySerialBean bean = new MySerialBean();
        bean.setId(123);
        bean.setName("Donald");
        Object data = this.template.requestBody("direct:marshal", (Object)bean);
        DataFormatEndpointSerializationTest.assertNotNull((Object)data);
        Object out = this.template.requestBody("direct:unmarshal", data);
        DataFormatEndpointSerializationTest.assertNotNull((Object)out);
        MySerialBean outBean = (MySerialBean)this.context.getTypeConverter().convertTo(MySerialBean.class, out);
        DataFormatEndpointSerializationTest.assertNotNull((Object)outBean);
        DataFormatEndpointSerializationTest.assertEquals((int)123, (int)outBean.getId());
        DataFormatEndpointSerializationTest.assertEquals((String)"Donald", (String)outBean.getName());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:unmarshal").to("dataformat:serialization:unmarshal");
                this.from("direct:marshal").to("dataformat:serialization:marshal");
            }
        };
    }
}

