/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.util.StopWatch;

public class DirectProducerBlockingTest
extends ContextTestSupport {
    public void testProducerBlocksForSuspendedConsumer() throws Exception {
        DirectEndpoint endpoint = this.getMandatoryEndpoint("direct:suspended", DirectEndpoint.class);
        endpoint.getConsumer().suspend();
        StopWatch watch = new StopWatch();
        try {
            this.template.sendBody("direct:suspended?block=true&timeout=2000", (Object)"hello world");
            DirectProducerBlockingTest.fail((String)"Expected CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DirectConsumerNotAvailableException cause = DirectProducerBlockingTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
            DirectProducerBlockingTest.assertIsInstanceOf(CamelExchangeException.class, cause);
            DirectProducerBlockingTest.assertTrue((watch.taken() > 1500L ? 1 : 0) != 0);
        }
    }

    public void testProducerBlocksWithNoConsumers() throws Exception {
        DirectEndpoint endpoint = this.getMandatoryEndpoint("direct:suspended", DirectEndpoint.class);
        endpoint.getConsumer().suspend();
        StopWatch watch = new StopWatch();
        try {
            this.template.sendBody("direct:start?block=true&timeout=2000", (Object)"hello world");
            DirectProducerBlockingTest.fail((String)"Expected CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DirectConsumerNotAvailableException cause = DirectProducerBlockingTest.assertIsInstanceOf(DirectConsumerNotAvailableException.class, e.getCause());
            DirectProducerBlockingTest.assertIsInstanceOf(CamelExchangeException.class, cause);
            DirectProducerBlockingTest.assertTrue((watch.taken() > 1500L ? 1 : 0) != 0);
        }
    }

    public void testProducerBlocksResumeTest() throws Exception {
        this.context.suspendRoute("foo");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    DirectProducerBlockingTest.this.log.info("Resuming consumer");
                    DirectProducerBlockingTest.this.context.resumeRoute("foo");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:suspended?block=true&timeout=5000", (Object)"hello world");
        this.assertMockEndpointsSatisfied();
        executor.shutdownNow();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:suspended").routeId("foo").to("mock:result");
            }
        };
    }
}

