/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.AntPathMatcherGenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class AntPathMatcherGenericFileFilterTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        AntPathMatcherGenericFileFilterTest.deleteDirectory("target/files");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        AntPathMatcherGenericFileFilter filterNotCaseSensitive = new AntPathMatcherGenericFileFilter(new String[]{"**/c*"});
        filterNotCaseSensitive.setCaseSensitive(false);
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("filter", (Object)new AntPathMatcherGenericFileFilter(new String[]{"**/c*"}));
        jndi.bind("caseInsensitiveFilter", (Object)filterNotCaseSensitive);
        return jndi;
    }

    public void testInclude() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result1");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World"});
        mock.setExpectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/files/ant-path-1/x/y/z", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-1/x/y/z", (Object)"Hello World 2", "CamelFileName", (Object)"b.TXT");
        this.assertMockEndpointsSatisfied();
    }

    public void testExclude() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result2");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 3", "Hello World 4"});
        mock.setExpectedMessageCount(3);
        this.template.sendBodyAndHeader("file://target/files/ant-path-2/x/y/z", (Object)"Hello World 1", "CamelFileName", (Object)"report.bak");
        this.template.sendBodyAndHeader("file://target/files/ant-path-2/x/y/z", (Object)"Hello World 2", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-2/x/y/z", (Object)"Hello World 3", "CamelFileName", (Object)"b.BAK");
        this.template.sendBodyAndHeader("file://target/files/ant-path-2/x/y/z", (Object)"Hello World 4", "CamelFileName", (Object)"b.TXT");
        this.assertMockEndpointsSatisfied();
    }

    public void testIncludesAndExcludes() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result3");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 4"});
        mock.setExpectedMessageCount(2);
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 1", "CamelFileName", (Object)"a.pdf");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 2", "CamelFileName", (Object)"m.pdf");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 3", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 4", "CamelFileName", (Object)"m.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 5", "CamelFileName", (Object)"b.bak");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 6", "CamelFileName", (Object)"m.bak");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 7", "CamelFileName", (Object)"ay.PDF");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 8", "CamelFileName", (Object)"my.Pdf");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 9", "CamelFileName", (Object)"by.TXT");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 10", "CamelFileName", (Object)"my.TxT");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 11", "CamelFileName", (Object)"by.BAK");
        this.template.sendBodyAndHeader("file://target/files/ant-path-3/x/y/z", (Object)"Hello World 12", "CamelFileName", (Object)"my.BaK");
        this.assertMockEndpointsSatisfied();
    }

    public void testIncludesAndExcludesAndFilter() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result4");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 3"});
        mock.setExpectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/files/ant-path-4/x/y/z", (Object)"Hello World 1", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-4/x/y/z", (Object)"Hello World 2", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-4/x/y/z", (Object)"Hello World 3", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-4/x/y/z", (Object)"Hello World 4", "CamelFileName", (Object)"Cy.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testIncludeAndAntFilterNotCaseSensitive() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result5");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World"});
        mock.setExpectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/files/ant-path-5/x/y/z", (Object)"Hello World", "CamelFileName", (Object)"report.TXT");
        this.assertMockEndpointsSatisfied();
    }

    public void testExcludeAndAntFilterNotCaseSensitive() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result6");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 4"});
        mock.setExpectedMessageCount(2);
        this.template.sendBodyAndHeader("file://target/files/ant-path-6/x/y/z", (Object)"Hello World 1", "CamelFileName", (Object)"report.bak");
        this.template.sendBodyAndHeader("file://target/files/ant-path-6/x/y/z", (Object)"Hello World 2", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-6/x/y/z", (Object)"Hello World 3", "CamelFileName", (Object)"b.BAK");
        this.template.sendBodyAndHeader("file://target/files/ant-path-6/x/y/z", (Object)"Hello World 4", "CamelFileName", (Object)"b.TXT");
        this.assertMockEndpointsSatisfied();
    }

    public void testIncludesAndExcludesAndAntFilterNotCaseSensitive() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result7");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 2", "Hello World 4", "Hello World 8", "Hello World 10"});
        mock.setExpectedMessageCount(4);
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 1", "CamelFileName", (Object)"a.pdf");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 2", "CamelFileName", (Object)"m.pdf");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 3", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 4", "CamelFileName", (Object)"m.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 5", "CamelFileName", (Object)"b.bak");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 6", "CamelFileName", (Object)"m.bak");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 7", "CamelFileName", (Object)"ay.PDF");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 8", "CamelFileName", (Object)"my.Pdf");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 9", "CamelFileName", (Object)"by.TXT");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 10", "CamelFileName", (Object)"my.TxT");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 11", "CamelFileName", (Object)"By.BAK");
        this.template.sendBodyAndHeader("file://target/files/ant-path-7/x/y/z", (Object)"Hello World 12", "CamelFileName", (Object)"My.BaK");
        this.assertMockEndpointsSatisfied();
    }

    public void testIncludesAndExcludesAndFilterAndAntFilterNotCaseSensitive() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result8");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World 3", "Hello World 4"});
        mock.setExpectedMessageCount(2);
        this.template.sendBodyAndHeader("file://target/files/ant-path-8/x/y/z", (Object)"Hello World 1", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-8/x/y/z", (Object)"Hello World 2", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-8/x/y/z", (Object)"Hello World 3", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader("file://target/files/ant-path-8/x/y/z", (Object)"Hello World 4", "CamelFileName", (Object)"Cy.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files/ant-path-1?recursive=true&antInclude=**/*.txt&antFilterCaseSensitive=true").convertBodyTo(String.class)).to("mock:result1");
                ((RouteDefinition)this.from("file://target/files/ant-path-5?recursive=true&antInclude=**/*.txt&antFilterCaseSensitive=false").convertBodyTo(String.class)).to("mock:result5");
                ((RouteDefinition)this.from("file://target/files/ant-path-2?recursive=true&antExclude=**/*.bak").convertBodyTo(String.class)).to("mock:result2");
                ((RouteDefinition)this.from("file://target/files/ant-path-6?recursive=true&antExclude=**/*.bak&antFilterCaseSensitive=false").convertBodyTo(String.class)).to("mock:result6");
                ((RouteDefinition)this.from("file://target/files/ant-path-3?recursive=true&antInclude=**/*.pdf,**/*.txt&antExclude=**/a*,**/b*").convertBodyTo(String.class)).to("mock:result3");
                ((RouteDefinition)this.from("file://target/files/ant-path-7?recursive=true&antInclude=**/*.Pdf,**/*.txt&antExclude=**/a*,**/b*&antFilterCaseSensitive=false").convertBodyTo(String.class)).to("mock:result7");
                ((RouteDefinition)this.from("file://target/files/ant-path-4?recursive=true&antInclude=**/*.txt&antExclude=**/a*&filter=#filter").convertBodyTo(String.class)).to("mock:result4");
                ((RouteDefinition)this.from("file://target/files/ant-path-8?recursive=true&antInclude=**/*.txt&antExclude=**/a*&filter=#caseInsensitiveFilter").convertBodyTo(String.class)).to("mock:result8");
            }
        };
    }
}

