/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileAbsolutePathIssueTest
extends ContextTestSupport {
    private String uri;
    private String start;
    private String done;

    @Override
    protected void setUp() throws Exception {
        FileAbsolutePathIssueTest.deleteDirectory("target/issue");
        FileAbsolutePathIssueTest.deleteDirectory("target/done");
        this.start = new File("target/issue").getAbsolutePath();
        this.done = new File("target/done").getAbsolutePath();
        this.uri = "file:" + this.start + "?move=" + this.done + "/${file:name}";
        super.setUp();
    }

    public void testMoveAbsolute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.done + "/hello.txt");
        this.template.sendBodyAndHeader("file:" + this.start, (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(FileAbsolutePathIssueTest.this.uri).to("mock:result");
            }
        };
    }
}

