/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeDoneFileIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumeDoneFileIssueTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testFileConsumeDoneFileIssue() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(5).create();
        this.template.sendBodyAndHeader("file:target/done", (Object)"A", "CamelFileName", (Object)"foo-a.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"B", "CamelFileName", (Object)"foo-b.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"C", "CamelFileName", (Object)"foo-c.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"D", "CamelFileName", (Object)"foo-d.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"E", "CamelFileName", (Object)"foo-e.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"E", "CamelFileName", (Object)"foo.done");
        FileConsumeDoneFileIssueTest.assertTrue((String)"Done file should exists", (boolean)new File("target/done/foo.done").exists());
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"A", "B", "C", "D", "E"});
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        FileConsumeDoneFileIssueTest.assertTrue((boolean)notify.matchesMockWaitTime());
        Thread.sleep(250L);
        FileConsumeDoneFileIssueTest.assertFalse((String)"Done file should be deleted", (boolean)new File("target/done/foo.done").exists());
    }

    public void testFileConsumseDynamicDoneFileName() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        this.template.sendBodyAndHeader("file:target/done2", (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/done2", (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file:target/done2", (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader("file:target/done2", (Object)"a", "CamelFileName", (Object)"a.txt.done");
        this.template.sendBodyAndHeader("file:target/done2", (Object)"b", "CamelFileName", (Object)"b.txt.done");
        this.template.sendBodyAndHeader("file:target/done2", (Object)"c", "CamelFileName", (Object)"c.txt.done");
        FileConsumeDoneFileIssueTest.assertTrue((String)"Done file should exists", (boolean)new File("target/done2/a.txt.done").exists());
        FileConsumeDoneFileIssueTest.assertTrue((String)"Done file should exists", (boolean)new File("target/done2/b.txt.done").exists());
        FileConsumeDoneFileIssueTest.assertTrue((String)"Done file should exists", (boolean)new File("target/done2/c.txt.done").exists());
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"A", "B", "C"});
        this.context.startRoute("bar");
        this.assertMockEndpointsSatisfied();
        FileConsumeDoneFileIssueTest.assertTrue((boolean)notify.matchesMockWaitTime());
        Thread.sleep(250L);
        FileConsumeDoneFileIssueTest.assertFalse((String)"Done file should be deleted", (boolean)new File("target/done2/a.txt.done").exists());
        FileConsumeDoneFileIssueTest.assertFalse((String)"Done file should be deleted", (boolean)new File("target/done2/b.txt.done").exists());
        FileConsumeDoneFileIssueTest.assertFalse((String)"Done file should be deleted", (boolean)new File("target/done2/c.txt.done").exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/done?doneFileName=foo.done").routeId("foo").noAutoStartup().convertBodyTo(String.class)).to("mock:result");
                ((RouteDefinition)this.from("file:target/done2?doneFileName=${file:name}.done").routeId("bar").noAutoStartup().convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

