/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeSingleDirectoryOnlyTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumeSingleDirectoryOnlyTest.deleteDirectory("target/singledirectoryonly");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/singledirectoryonly", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader("file://target/singledirectoryonly", (Object)"Bye World", "CamelFileName", (Object)"report2.txt");
        this.template.sendBodyAndHeader("file://target/singledirectoryonly/2008", (Object)"2008 Report", "CamelFileName", (Object)"report2008.txt");
    }

    public void testConsumeFileOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setResultWaitTime(15000L);
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/singledirectoryonly/?recursive=false&delete=true").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

