/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerAbsolutePathWithAbsoluteMoveTest
extends ContextTestSupport {
    private String base;

    @Override
    protected void setUp() throws Exception {
        FileConsumerAbsolutePathWithAbsoluteMoveTest.deleteDirectory("target/reports");
        this.base = new File("").getAbsolutePath() + "/target/reports";
        super.setUp();
    }

    public void testConsumeFromAbsolutePath() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists(this.base + "/done/paris.txt");
        this.template.sendBodyAndHeader("file:target/reports", (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://" + FileConsumerAbsolutePathWithAbsoluteMoveTest.this.base + "?move=" + FileConsumerAbsolutePathWithAbsoluteMoveTest.this.base + "/done/${file:onlyname}").convertBodyTo(String.class)).to("mock:report");
            }
        };
    }
}

