/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerBridgeRouteExceptionHandlerTest
extends ContextTestSupport {
    private MyReadLockStrategy myReadLockStrategy = new MyReadLockStrategy();

    public void testCustomExceptionHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Error Forced to simulate no space on device"});
        this.template.sendBodyAndHeader("file:target/nospace", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/nospace", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
        FileConsumerBridgeRouteExceptionHandlerTest.assertEquals((String)"Should pickup bye.txt file 2 times", (int)2, (int)this.myReadLockStrategy.getCounter());
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myReadLockStrategy", (Object)this.myReadLockStrategy);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)((OnExceptionDefinition)this.onException(IOException.class).handled(true).log("IOException occurred due: ${exception.message}")).transform().simple("Error ${exception.message}")).to("mock:error");
                ((RouteDefinition)this.from("file:target/nospace?exclusiveReadLockStrategy=#myReadLockStrategy&consumer.bridgeErrorHandler=true").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class MyReadLockStrategy
    implements GenericFileExclusiveReadLockStrategy<File> {
        private int counter;

        private MyReadLockStrategy() {
        }

        public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) throws Exception {
        }

        public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
            if (file.getFileNameOnly().equals("bye.txt") && this.counter++ == 0) {
                throw new IOException("Forced to simulate no space on device");
            }
            return true;
        }

        public void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        }

        public void setTimeout(long timeout) {
        }

        public void setCheckInterval(long checkInterval) {
        }

        public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

