/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;

public class FileConsumerCustomSchedulerTest
extends ContextTestSupport {
    private MyScheduler scheduler = new MyScheduler();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myScheduler", (Object)this.scheduler);
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        FileConsumerCustomSchedulerTest.deleteDirectory("target/file/custom");
        super.setUp();
    }

    public void testCustomScheduler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/file/custom", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        FileConsumerCustomSchedulerTest.assertEquals((int)1, (int)this.scheduler.getCounter());
        FileConsumerCustomSchedulerTest.assertEquals((String)"bar", (String)this.scheduler.getFoo());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/file/custom?scheduler=#myScheduler&scheduler.foo=bar").routeId("foo").noAutoStartup().to("mock:result");
            }
        };
    }

    private static final class MyScheduler
    implements ScheduledPollConsumerScheduler {
        private CamelContext camelContext;
        private Timer timer;
        private TimerTask timerTask;
        private volatile int counter;
        private String foo;

        private MyScheduler() {
        }

        public void onInit(Consumer consumer) {
        }

        public void scheduleTask(final Runnable task) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    MyScheduler.this.counter++;
                    task.run();
                }
            };
        }

        public void unscheduleTask() {
        }

        public int getCounter() {
            return this.counter;
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public void startScheduler() {
            this.timer = new Timer();
            this.timer.schedule(this.timerTask, 100L);
        }

        public boolean isSchedulerStarted() {
            return true;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void shutdown() throws Exception {
            this.timerTask.cancel();
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }
    }
}

