/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumerIdempotentTest;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerIdempotentKeyNameAndSizeTest
extends FileConsumerIdempotentTest {
    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/idempotent/?idempotent=true&idempotentKey=${file:onlyname}-${file:size}&move=done/${file:name}&delay=10").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public void testIdempotentDiffSize() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBodyAndHeader("file://target/idempotent", (Object)"Bye World", "CamelFileName", (Object)"report.txt");
        this.assertMockEndpointsSatisfied();
    }
}

