/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public class FileConsumerPollStrategyNotBeginTest
extends ContextTestSupport {
    private static int counter;
    private static volatile String event;
    private String fileUrl = "file://target/pollstrategy/?consumer.pollStrategy=#myPoll&noop=true&initialDelay=0&delay=10";

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myPoll", (Object)new MyPollStrategy());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FileConsumerPollStrategyNotBeginTest.deleteDirectory("target/pollstrategy");
        this.template.sendBodyAndHeader("file:target/pollstrategy/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testFirstPollNotBegin() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        Thread.sleep(100L);
        FileConsumerPollStrategyNotBeginTest.assertTrue((boolean)event.startsWith("beginbegincommit"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerPollStrategyNotBeginTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    static {
        event = "";
    }

    private static class MyPollStrategy
    implements PollingConsumerPollStrategy {
        private MyPollStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            event = event + "begin";
            return counter++ != 0;
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            event = event + "commit";
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
            event = event + "rollback";
            return false;
        }
    }
}

