/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;

public class FileConsumerSharedThreadPollTest
extends ContextTestSupport {
    private ScheduledExecutorService pool;
    private SimpleRegistry registry = new SimpleRegistry();

    @Override
    protected void setUp() throws Exception {
        FileConsumerSharedThreadPollTest.deleteDirectory("target/a");
        FileConsumerSharedThreadPollTest.deleteDirectory("target/b");
        super.setUp();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        return new DefaultCamelContext((Registry)this.registry);
    }

    public void testSharedThreadPool() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(0).header("threadName")).isEqualTo(mock.message(1).header("threadName"));
        this.template.sendBodyAndHeader("file:target/a", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/b", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                FileConsumerSharedThreadPollTest.this.pool = new ThreadPoolBuilder((CamelContext)FileConsumerSharedThreadPollTest.this.context).poolSize(1).buildScheduled((Object)this, "MySharedPool");
                FileConsumerSharedThreadPollTest.this.registry.put((Object)"myPool", (Object)FileConsumerSharedThreadPollTest.this.pool);
                this.from("file:target/a?scheduledExecutorService=#myPool").routeId("a").to("direct:shared");
                this.from("file:target/b?scheduledExecutorService=#myPool").routeId("b").to("direct:shared");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:shared").routeId("shared").convertBodyTo(String.class)).log("Get ${file:name} using ${threadName}")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setHeader("threadName", (Object)Thread.currentThread().getName());
                    }
                })).to("mock:result");
            }
        };
    }
}

