/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerSkipDotFilesTest
extends ContextTestSupport {
    private String fileUrl = "file://target/dotfiles/";

    @Override
    protected void setUp() throws Exception {
        FileConsumerSkipDotFilesTest.deleteDirectory("target/dotfiles");
        super.setUp();
    }

    public void testSkipDotFiles() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/dotfiles/", (Object)"This is a dot file", "CamelFileName", (Object)".skipme");
        mock.setResultWaitTime(2000L);
        mock.assertIsSatisfied();
    }

    public void testSkipDotFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/dotfiles/", (Object)"This is a dot file", "CamelFileName", (Object)".skipme");
        this.template.sendBodyAndHeader("file:target/dotfiles/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerSkipDotFilesTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

