/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;

public class FileConsumerSuspendAndResumeTest
extends ContextTestSupport {
    private MyPolicy myPolicy = new MyPolicy();

    @Override
    protected void setUp() throws Exception {
        FileConsumerSuspendAndResumeTest.deleteDirectory("target/suspended");
        super.setUp();
    }

    public void testConsumeSuspendAndResumeFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/suspended", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader("file://target/suspended", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        String[] files = new File("target/suspended/").list();
        FileConsumerSuspendAndResumeTest.assertNotNull((Object)files);
        FileConsumerSuspendAndResumeTest.assertEquals((String)"The file should exists", (int)1, (int)files.length);
        this.oneExchangeDone.reset();
        mock.reset();
        mock.expectedMessageCount(1);
        this.myPolicy.resumeConsumer();
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        files = new File("target/suspended/").list();
        FileConsumerSuspendAndResumeTest.assertNotNull((Object)files);
        FileConsumerSuspendAndResumeTest.assertEquals((String)"The file should exists", (int)0, (int)files.length);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file://target/suspended?maxMessagesPerPoll=1&delete=true&initialDelay=0&delay=10").routePolicy(new RoutePolicy[]{FileConsumerSuspendAndResumeTest.this.myPolicy}).id("myRoute")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class MyPolicy
    extends RoutePolicySupport {
        private int counter;
        private Consumer consumer;

        private MyPolicy() {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            this.consumer = route.getConsumer();
            if (this.counter++ == 0) {
                try {
                    super.stopConsumer(this.consumer);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        public void resumeConsumer() throws Exception {
            super.startConsumer(this.consumer);
        }
    }
}

