/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;

public class FileEagerDeleteTargetFileTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileEagerDeleteTargetFileTest.deleteDirectory("target/eagerdelete");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/eagerdelete", (Object)"Hello World", "CamelFileName", (Object)"world.txt");
    }

    public void testEagerDeleteTargetFileTrue() throws Exception {
        this.template.sendBodyAndHeader("file://target/eagerdelete?tempFileName=inprogress-${file:name}&eagerDeleteTargetFile=true", (Object)"Bye World", "CamelFileName", (Object)"world.txt");
        File file = new File("target/eagerdelete/world.txt");
        FileEagerDeleteTargetFileTest.assertTrue((String)"File should exist", (boolean)file.exists());
        FileEagerDeleteTargetFileTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }

    public void testEagerDeleteTargetFileFalse() throws Exception {
        this.template.sendBodyAndHeader("file://target/eagerdelete?tempFileName=inprogress-${file:name}&eagerDeleteTargetFile=false", (Object)"Bye World", "CamelFileName", (Object)"world.txt");
        File file = new File("target/eagerdelete/world.txt");
        FileEagerDeleteTargetFileTest.assertTrue((String)"File should exist", (boolean)file.exists());
        FileEagerDeleteTargetFileTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }

    public void testEagerDeleteTargetFileDefault() throws Exception {
        this.template.sendBodyAndHeader("file://target/eagerdelete?tempFileName=inprogress-${file:name}", (Object)"Bye World", "CamelFileName", (Object)"world.txt");
        File file = new File("target/eagerdelete/world.txt");
        FileEagerDeleteTargetFileTest.assertTrue((String)"File should exist", (boolean)file.exists());
        FileEagerDeleteTargetFileTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

