/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileKeepLastModifiedTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileKeepLastModifiedTest.deleteDirectory("target/keep");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/keep", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testKeepLastModified() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/keep?noop=true").delay(3000L).to(new String[]{"file://target/keep/out?keepLastModified=true", "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/keep/out/hello.txt");
        ((ValueBuilder)mock.message(0).header("CamelFileLastModified")).isNotNull();
        this.assertMockEndpointsSatisfied();
        long t1 = (Long)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileLastModified", Long.TYPE);
        long t2 = new File("target/keep/out/hello.txt").lastModified();
        FileKeepLastModifiedTest.assertEquals((String)"Timestamp should have been kept", (long)t1, (long)t2);
    }

    public void testDoNotKeepLastModified() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/keep?noop=true").delay(3000L).to(new String[]{"file://target/keep/out?keepLastModified=false", "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/keep/out/hello.txt");
        ((ValueBuilder)mock.message(0).header("CamelFileLastModified")).isNotNull();
        this.assertMockEndpointsSatisfied();
        long t1 = (Long)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileLastModified", Long.TYPE);
        long t2 = new File("target/keep/out/hello.txt").lastModified();
        FileKeepLastModifiedTest.assertNotSame((String)"Timestamp should NOT have been kept", (Object)t1, (Object)t2);
    }

    public void testDoNotKeepLastModifiedIsDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/keep?noop=true").delay(3000L).to(new String[]{"file://target/keep/out", "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/keep/out/hello.txt");
        ((ValueBuilder)mock.message(0).header("CamelFileLastModified")).isNotNull();
        this.assertMockEndpointsSatisfied();
        long t1 = (Long)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileLastModified", Long.TYPE);
        long t2 = new File("target/keep/out/hello.txt").lastModified();
        FileKeepLastModifiedTest.assertNotSame((String)"Timestamp should NOT have been kept", (Object)t1, (Object)t2);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

