/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;

public class FilePollingConsumerTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilePollingConsumerTest.deleteDirectory("target/enrich");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPollingConsumer() throws Exception {
        this.template.sendBodyAndHeader("file:target/enrich", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        PollingConsumer consumer = this.context.getEndpoint("file:target/enrich").createPollingConsumer();
        consumer.start();
        Exchange exchange = consumer.receive(5000L);
        FilePollingConsumerTest.assertNotNull((Object)exchange);
        FilePollingConsumerTest.assertEquals((String)"Hello World", (String)((String)exchange.getIn().getBody(String.class)));
        Thread.sleep(500L);
        this.template.sendBodyAndHeader("file:target/enrich", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        Thread.sleep(1000L);
        File file = new File("target/enrich/bye.txt");
        FilePollingConsumerTest.assertTrue((String)("File should exist " + file), (boolean)file.exists());
        consumer.stop();
    }
}

