/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFileProducer;

public class FileProduceTempFileNameTest
extends ContextTestSupport {
    private String fileUrl = "file://target/tempandrename/?tempFileName=inprogress-${file:name.noext}.tmp";

    @Override
    protected void setUp() throws Exception {
        FileProduceTempFileNameTest.deleteDirectory("target/tempandrename");
        super.setUp();
    }

    public void testCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUrl);
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)"claus.txt");
        String tempFileName = producer.createTempFileName(exchange, "target/tempandrename/claus.txt");
        FileProduceTempFileNameTest.assertDirectoryEquals("target/tempandrename/inprogress-claus.tmp", tempFileName);
    }

    public void testNoPathCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUrl);
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)"claus.txt");
        String tempFileName = producer.createTempFileName(exchange, ".");
        FileProduceTempFileNameTest.assertDirectoryEquals("inprogress-claus.tmp", tempFileName);
    }

    public void testTempFileName() throws Exception {
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/tempandrename/hello.txt");
        FileProduceTempFileNameTest.assertEquals((String)("The generated file should exists: " + file), (boolean)true, (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").to(FileProduceTempFileNameTest.this.fileUrl);
            }
        };
    }
}

