/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFileProducer;

public class FileProduceTempPrefixTest
extends ContextTestSupport {
    private String fileUrl = "file://target/tempandrename/?tempPrefix=inprogress.";

    @Override
    protected void setUp() throws Exception {
        FileProduceTempPrefixTest.deleteDirectory("target/tempandrename");
        super.setUp();
    }

    public void testCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUrl);
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)"claus.txt");
        String tempFileName = producer.createTempFileName(exchange, "target/tempandrename/claus.txt");
        FileProduceTempPrefixTest.assertDirectoryEquals("target/tempandrename/inprogress.claus.txt", tempFileName);
    }

    public void testCreateTempFileNameUsingComplexName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUrl);
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)"foo/claus.txt");
        String tempFileName = producer.createTempFileName(exchange, "target/tempandrename/foo/claus.txt");
        FileProduceTempPrefixTest.assertDirectoryEquals("target/tempandrename/foo/inprogress.claus.txt", tempFileName);
    }

    public void testNoPathCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUrl);
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)"claus.txt");
        String tempFileName = producer.createTempFileName(exchange, ".");
        FileProduceTempPrefixTest.assertDirectoryEquals("inprogress.claus.txt", tempFileName);
    }

    public void testTempPrefix() throws Exception {
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/tempandrename/hello.txt");
        FileProduceTempPrefixTest.assertEquals((String)("The generated file should exists: " + file), (boolean)true, (boolean)file.exists());
    }

    public void testTempPrefixUUIDFilename() throws Exception {
        this.template.sendBody("direct:a", (Object)"Bye World");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").to(FileProduceTempPrefixTest.this.fileUrl);
            }
        };
    }
}

