/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;

public class FileProducerFileExistFailTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerFileExistFailTest.deleteDirectory("target/file");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/file", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists("target/file/hello.txt", "Hello World");
        try {
            this.template.sendBodyAndHeader("file://target/file?fileExist=Fail", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
            FileProducerFileExistFailTest.fail((String)"Should have thrown a GenericFileOperationFailedException");
        }
        catch (CamelExecutionException e) {
            GenericFileOperationFailedException cause = FileProducerFileExistFailTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
            FileProducerFileExistFailTest.assertEquals((String)FileUtil.normalizePath((String)"File already exist: target/file/hello.txt. Cannot write new file."), (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file?noop=true&delay=1000").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

