/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.FileUtil;
import org.junit.Test;

public class FileRouteOnDosWithNoVolTest
extends ContextTestSupport {
    private String path;

    @Override
    public void setUp() throws Exception {
        int dp;
        File dir = new File("target/reports/dosnovol");
        FileRouteOnDosWithNoVolTest.deleteDirectory(dir);
        this.path = dir.getAbsolutePath();
        if (FileUtil.isWindows() && (dp = this.path.indexOf(":\\")) > 0) {
            this.path = this.path.substring(dp + 1).replace('\\', '/');
        }
        super.setUp();
    }

    @Test
    public void testRouteFileToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.path + "/route/out/hello.txt");
        this.template.sendBodyAndHeader("file://" + this.path + "/route/poller", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteFromFileOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://" + this.path + "/from/poller", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteToFileOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.path + "/to/out/hello.txt");
        this.template.sendBodyAndHeader("direct:report", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://" + FileRouteOnDosWithNoVolTest.this.path + "/route/poller").to(new String[]{"file://" + FileRouteOnDosWithNoVolTest.this.path + "/route/out", "mock:result"});
                this.from("file://" + FileRouteOnDosWithNoVolTest.this.path + "/from/poller").to("mock:result");
                this.from("direct:report").to(new String[]{"file://" + FileRouteOnDosWithNoVolTest.this.path + "/to/out", "mock:result"});
            }
        };
    }
}

