/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Comparator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FileSorterRefTest
extends ContextTestSupport {
    private String fileUrl = "file://target/filesorter/?sorter=#mySorter";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("mySorter", new MyFileSorter());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        FileSorterRefTest.deleteDirectory("target/filesorter");
        super.setUp();
        this.template.sendBodyAndHeader("file:target/filesorter/", (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        this.template.sendBodyAndHeader("file:target/filesorter/", (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader("file:target/filesorter/", (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.txt");
    }

    public void testSortFiles() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileSorterRefTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Copenhagen", "Hello London", "Hello Paris"});
        this.assertMockEndpointsSatisfied();
    }

    public class MyFileSorter<T>
    implements Comparator<GenericFile<T>> {
        @Override
        public int compare(GenericFile<T> o1, GenericFile<T> o2) {
            return o1.getFileName().compareToIgnoreCase(o2.getFileName());
        }
    }
}

