/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class FilerConsumerDoneFileNameDeleteTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerConsumerDoneFileNameDeleteTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("file:target/done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Thread.sleep(250L);
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.oneExchangeDone.reset();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/done", (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/done/done");
        FilerConsumerDoneFileNameDeleteTest.assertFalse((String)("Done file should be deleted: " + file), (boolean)file.exists());
        file = new File("target/done/hello.txt");
        FilerConsumerDoneFileNameDeleteTest.assertFalse((String)("Original file should be deleted: " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/done?doneFileName=done&delete=true&initialDelay=0&delay=10").to("mock:result");
            }
        };
    }
}

