/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class FilerConsumerMoveFailedDoneFileNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerConsumerMoveFailedDoneFileNameTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:input").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/done/done");
        FilerConsumerMoveFailedDoneFileNameTest.assertFalse((String)("Done file should be deleted: " + file), (boolean)file.exists());
        file = new File("target/done/failed/hello.txt");
        FilerConsumerMoveFailedDoneFileNameTest.assertTrue((String)("Original file should be moved: " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/done?doneFileName=done&initialDelay=0&delay=10&moveFailed=failed").to("mock:input")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

