/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FilerProducerFileNamesTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerProducerFileNamesTest.deleteDirectory("target/reports");
        super.setUp();
    }

    public void testProducerWithMessageIdAsFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint("direct:report");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"This is a good report");
        FileEndpoint fileEndpoint = this.resolveMandatoryEndpoint("file:target/reports/report.txt", FileEndpoint.class);
        String id = fileEndpoint.getGeneratedFileName(exchange.getIn());
        this.template.send("direct:report", exchange);
        File file = new File("target/reports/" + id);
        FilerProducerFileNamesTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
    }

    public void testProducerWithHeaderFileName() throws Exception {
        this.template.sendBody("direct:report2", (Object)"This is super good report");
        File file = new File("target/report-super.txt");
        FilerProducerFileNamesTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:report").to("file:target/reports/");
                ((RouteDefinition)this.from("direct:report2").setHeader("CamelFileName", (Expression)this.constant("report-super.txt"))).to("file:target/");
            }
        };
    }
}

