/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileComponent;
import org.apache.camel.component.file.GenericFileEndpoint;

public class NewFileConsumeTest
extends ContextTestSupport {
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    protected void setUp() throws Exception {
        NewFileConsumeTest.deleteDirectory("target/consumefile");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewFileConsumer() throws Exception {
        FileComponent comp = new FileComponent();
        comp.setCamelContext((CamelContext)this.context);
        NewFileConsumeTest.createDirectory("target/consumefile");
        FileOutputStream fos = new FileOutputStream(new File("target/consumefile/hello.txt"));
        try {
            fos.write("Hello World".getBytes());
        }
        finally {
            fos.close();
        }
        GenericFileEndpoint endpoint = comp.createEndpoint("file://target/consumefile", "target/consumefile", new HashMap());
        Consumer consumer = endpoint.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
                TestCase.assertNotNull((Object)exchange);
                String body = (String)exchange.getIn().getBody(String.class);
                TestCase.assertEquals((String)"Hello World", (String)body);
                NewFileConsumeTest.this.latch.countDown();
            }
        });
        consumer.start();
        this.latch.await();
        consumer.stop();
    }
}

