/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.util.FileUtil;

public class GenericFileDeleteProcessStrategyTest
extends ContextTestSupport {
    private static int existsCounter;
    private static int deleteCounter;

    public void testTroubleDeletingFile() throws Exception {
        deleteCounter = 0;
        existsCounter = 0;
        GenericFileEndpoint endpoint = (GenericFileEndpoint)this.context.getEndpoint("file://target/foo", GenericFileEndpoint.class);
        Exchange exchange = endpoint.createExchange();
        GenericFile file = new GenericFile();
        file.setAbsoluteFilePath("target/foo/me.txt");
        GenericFileDeleteProcessStrategy strategy = new GenericFileDeleteProcessStrategy();
        strategy.commit((GenericFileOperations)new MyGenericFileOperations(), endpoint, exchange, file);
        GenericFileDeleteProcessStrategyTest.assertEquals((String)"Should have tried to delete file 2 times", (int)2, (int)deleteCounter);
        GenericFileDeleteProcessStrategyTest.assertEquals((String)"Should have tried to delete file 2 times", (int)2, (int)existsCounter);
    }

    public void testCannotDeleteFile() throws Exception {
        deleteCounter = 0;
        existsCounter = 0;
        GenericFileEndpoint endpoint = (GenericFileEndpoint)this.context.getEndpoint("file://target/foo", GenericFileEndpoint.class);
        Exchange exchange = endpoint.createExchange();
        GenericFile file = new GenericFile();
        file.setAbsoluteFilePath("target/foo/boom.txt");
        GenericFileDeleteProcessStrategy strategy = new GenericFileDeleteProcessStrategy();
        try {
            strategy.commit((GenericFileOperations)new MyGenericFileOperations(), endpoint, exchange, file);
            GenericFileDeleteProcessStrategyTest.fail((String)"Should have thrown an exception");
        }
        catch (GenericFileOperationFailedException e) {
            // empty catch block
        }
        GenericFileDeleteProcessStrategyTest.assertEquals((String)"Should have tried to delete file 3 times", (int)3, (int)deleteCounter);
        GenericFileDeleteProcessStrategyTest.assertEquals((String)"Should have tried to delete file 3 times", (int)3, (int)existsCounter);
    }

    private static class MyGenericFileOperations
    implements GenericFileOperations<Object> {
        private MyGenericFileOperations() {
        }

        public void setEndpoint(GenericFileEndpoint<Object> endpoint) {
        }

        public boolean deleteFile(String name) throws GenericFileOperationFailedException {
            deleteCounter++;
            return false;
        }

        public boolean existsFile(String name) throws GenericFileOperationFailedException {
            existsCounter++;
            if (FileUtil.normalizePath((String)"target/foo/boom.txt").equals(name)) {
                return true;
            }
            return existsCounter <= 1;
        }

        public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
            return false;
        }

        public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
            return false;
        }

        public boolean retrieveFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
            return false;
        }

        public void releaseRetreivedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
        }

        public boolean storeFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
            return false;
        }

        public String getCurrentDirectory() throws GenericFileOperationFailedException {
            return null;
        }

        public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        }

        public void changeToParentDirectory() throws GenericFileOperationFailedException {
        }

        public List<Object> listFiles() throws GenericFileOperationFailedException {
            return null;
        }

        public List<Object> listFiles(String path) throws GenericFileOperationFailedException {
            return null;
        }
    }
}

