/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.language.LanguageComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class LanguageComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        LanguageComponent comp = (LanguageComponent)this.context.getComponent("language", LanguageComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("language:simple:foo?transform=false");
        LanguageComponentConfigurationAndDocumentationTest.assertEquals((Object)"false", (Object)conf.getParameter("transform"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        LanguageComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        LanguageComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"script\": { \"type\": \"java.lang.String\" }"));
        LanguageComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"cacheScript\": { \"type\": \"boolean\" }"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        if (LanguageComponentConfigurationAndDocumentationTest.isJavaVersion("1.6")) {
            return;
        }
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("language");
        LanguageComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML if on Java 7", (Object)html);
    }
}

