/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.PropertyPlaceholderDelegateRegistry;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.junit.Before;
import org.junit.Test;

public class LogCustomFormatterTest
extends ContextTestSupport {
    private TestExchangeFormatter exchangeFormatter;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Logger.getLogger(LogCustomFormatterTest.class).removeAllAppenders();
        Logger.getLogger(LogCustomFormatterTest.class).addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        Logger.getLogger(LogCustomFormatterTest.class).setLevel(Level.TRACE);
    }

    @Test
    public void testCustomFormatterInComponent() throws Exception {
        this.context.stop();
        LogComponent log = new LogComponent();
        this.exchangeFormatter = new TestExchangeFormatter();
        log.setExchangeFormatter((ExchangeFormatter)this.exchangeFormatter);
        this.context.addComponent("log", (Component)log);
        this.context.start();
        String endpointUri = "log:" + LogCustomFormatterTest.class.getCanonicalName();
        this.template.requestBody(endpointUri, (Object)"Hello World");
        this.template.requestBody(endpointUri, (Object)"Hello World");
        this.template.requestBody(endpointUri + "2", (Object)"Hello World");
        this.template.requestBody(endpointUri + "2", (Object)"Hello World");
        LogCustomFormatterTest.assertEquals((int)4, (int)this.exchangeFormatter.getCounter());
    }

    @Test
    public void testCustomFormatterInRegistry() throws Exception {
        this.context.stop();
        this.exchangeFormatter = new TestExchangeFormatter();
        JndiRegistry registry = this.getRegistryAsJndi();
        registry.bind("logFormatter", (Object)this.exchangeFormatter);
        this.context.start();
        String endpointUri = "log:" + LogCustomFormatterTest.class.getCanonicalName();
        this.template.requestBody(endpointUri, (Object)"Hello World");
        this.template.requestBody(endpointUri, (Object)"Hello World");
        this.template.requestBody(endpointUri + "2", (Object)"Hello World");
        this.template.requestBody(endpointUri + "2", (Object)"Hello World");
        LogCustomFormatterTest.assertEquals((int)4, (int)this.exchangeFormatter.getCounter());
    }

    @Test
    public void testCustomFormatterInRegistryOptions() throws Exception {
        this.context.stop();
        this.exchangeFormatter = new TestExchangeFormatter();
        JndiRegistry registry = this.getRegistryAsJndi();
        registry.bind("logFormatter", (Object)this.exchangeFormatter);
        LogCustomFormatterTest.assertEquals((String)"", (String)this.exchangeFormatter.getPrefix());
        this.context.start();
        String endpointUri = "log:" + LogCustomFormatterTest.class.getCanonicalName() + "?prefix=foo";
        this.template.requestBody(endpointUri, (Object)"Hello World");
        this.template.requestBody(endpointUri, (Object)"Hello World");
        LogCustomFormatterTest.assertEquals((int)2, (int)this.exchangeFormatter.getCounter());
        LogCustomFormatterTest.assertEquals((String)"foo", (String)this.exchangeFormatter.getPrefix());
    }

    @Test
    public void testCustomFormatterInRegistryUnknownOption() throws Exception {
        this.context.stop();
        this.exchangeFormatter = new TestExchangeFormatter();
        JndiRegistry registry = this.getRegistryAsJndi();
        registry.bind("logFormatter", (Object)this.exchangeFormatter);
        LogCustomFormatterTest.assertEquals((String)"", (String)this.exchangeFormatter.getPrefix());
        this.context.start();
        try {
            String endpointUri2 = "log:" + LogCustomFormatterTest.class.getCanonicalName() + "?prefix=foo&bar=no";
            this.template.requestBody(endpointUri2, (Object)"Hello World");
            LogCustomFormatterTest.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            ResolveEndpointFailedException cause = LogCustomFormatterTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            LogCustomFormatterTest.assertTrue((boolean)cause.getMessage().endsWith("Unknown parameters=[{bar=no}]"));
        }
    }

    @Test
    public void testFormatterNotPickedUpWithDifferentKey() throws Exception {
        this.context.stop();
        this.exchangeFormatter = new TestExchangeFormatter();
        JndiRegistry registry = this.getRegistryAsJndi();
        registry.bind("anotherFormatter", (Object)this.exchangeFormatter);
        this.context.start();
        String endpointUri = "log:" + LogCustomFormatterTest.class.getCanonicalName();
        this.template.requestBody(endpointUri, (Object)"Hello World");
        this.template.requestBody(endpointUri, (Object)"Hello World");
        this.template.requestBody(endpointUri + "2", (Object)"Hello World");
        this.template.requestBody(endpointUri + "2", (Object)"Hello World");
        LogCustomFormatterTest.assertEquals((int)0, (int)this.exchangeFormatter.getCounter());
    }

    private JndiRegistry getRegistryAsJndi() {
        JndiRegistry registry = null;
        if (this.context.getRegistry() instanceof PropertyPlaceholderDelegateRegistry) {
            registry = (JndiRegistry)((PropertyPlaceholderDelegateRegistry)this.context.getRegistry()).getRegistry();
        } else if (this.context.getRegistry() instanceof JndiRegistry) {
            registry = (JndiRegistry)this.context.getRegistry();
        } else {
            LogCustomFormatterTest.fail((String)"Could not determine Registry type");
        }
        return registry;
    }

    public static class TestExchangeFormatter
    implements ExchangeFormatter {
        private int counter;
        private boolean addTen;
        private String prefix = "";

        public String format(Exchange exchange) {
            this.counter += this.addTen ? 10 : 1;
            return this.prefix + exchange.toString();
        }

        public int getCounter() {
            return this.counter;
        }

        public boolean isAddTen() {
            return this.addTen;
        }

        public void setAddTen(boolean addTen) {
            this.addTen = addTen;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

