/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.CamelLogProcessor;

public class LogEndpointTest
extends ContextTestSupport {
    private static Exchange logged;

    public void testLogEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        LogEndpointTest.assertNotNull((Object)logged);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                LogEndpoint end = new LogEndpoint();
                end.setCamelContext((CamelContext)LogEndpointTest.this.context);
                end.setLogger((Processor)new MyLogger());
                TestCase.assertEquals((String)"log:myLogger", (String)end.getEndpointUri());
                ((RouteDefinition)this.from("direct:start").to((Endpoint)end)).to("mock:result");
            }
        };
    }

    private static class MyLogger
    extends CamelLogProcessor {
        private MyLogger() {
        }

        public void process(Exchange exchange) throws Exception {
            super.process(exchange);
            logged = exchange;
        }

        public String toString() {
            return "myLogger";
        }
    }
}

