/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class MockEndpointTimeClauseTest
extends ContextTestSupport {
    public void testReceivedTimestamp() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((ValueBuilder)mock.message(0).property("CamelCreatedTimestamp")).isNotNull();
        ((ValueBuilder)mock.message(0).property("CamelCreatedTimestamp")).isInstanceOf(Date.class);
        ((ValueBuilder)mock.message(0).property("CamelReceivedTimestamp")).isNotNull();
        ((ValueBuilder)mock.message(0).property("CamelReceivedTimestamp")).isInstanceOf(Date.class);
        this.template.sendBody("direct:a", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    public void testAssertPeriod() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.setAssertPeriod(1000L);
        this.template.sendBody("direct:a", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    public void testAssertPeriodNot() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.setAssertPeriod(1000L);
        this.template.sendBody("direct:a", (Object)"A");
        this.template.sendBody("direct:a", (Object)"B");
        mock.assertIsNotSatisfied();
    }

    public void testAssertPeriodSecondMessageArrives() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.setAssertPeriod(2000L);
        this.template.sendBody("direct:a", (Object)"A");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MockEndpointTimeClauseTest.this.template.sendBody("direct:a", (Object)"B");
            }
        });
        try {
            mock.assertIsSatisfied();
            MockEndpointTimeClauseTest.fail((String)"Should have thrown an exception");
        }
        catch (AssertionError e) {
            MockEndpointTimeClauseTest.assertEquals((String)"mock://result Received message count. Expected: <1> but was: <2>", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testNoAssertPeriodSecondMessageArrives() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"A");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MockEndpointTimeClauseTest.this.template.sendBody("direct:a", (Object)"B");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    public void testArrivesBeforeNext() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(0).arrives().noLaterThan(2).seconds().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(500L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    public void testArrivesAfterPrevious() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(1).arrives().noLaterThan(2).seconds().afterPrevious();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(500L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    public void testArrivesBeforeAndAfter() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.message(1).arrives().noLaterThan(500).millis().afterPrevious();
        mock.message(1).arrives().noLaterThan(1000).millis().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(100L);
        this.template.sendBody("direct:a", (Object)"B");
        Thread.sleep(200L);
        this.template.sendBody("direct:a", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    public void testArrivesWithinAfterPrevious() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(1).arrives().between(1, 4).seconds().afterPrevious();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(1500L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    public void testArrivesWithinBeforeNext() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(0).arrives().between(1, 4).seconds().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(1500L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    public void testArrivesAllMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(5);
        mock.allMessages().arrives().noLaterThan(1).seconds().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        this.template.sendBody("direct:a", (Object)"B");
        Thread.sleep(100L);
        this.template.sendBody("direct:a", (Object)"C");
        Thread.sleep(150L);
        this.template.sendBody("direct:a", (Object)"D");
        Thread.sleep(200L);
        this.template.sendBody("direct:a", (Object)"E");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to("mock:result");
            }
        };
    }
}

