/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ChoiceDefinition;

public class PropertiesComponentEIPChoiceConvertBodyToTest
extends ContextTestSupport {
    public void testConvertToBytesCharset() throws Exception {
        byte[] body = "Hello World".getBytes("iso-8859-1");
        this.getMockEndpoint("mock:null").expectedMessageCount(0);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testNullBody() throws Exception {
        this.getMockEndpoint("mock:null").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isNotNull()).convertBodyTo(byte[].class, "{{myCoolCharset}}")).to("mock:result")).otherwise().to("mock:null");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setCamelContext(context);
        pc.setLocations(new String[]{"classpath:org/apache/camel/component/properties/myproperties.properties"});
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

