/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;

public class PropertiesComponentLocationWithJvmPropertyTest
extends ContextTestSupport {
    public void testProperty() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.end");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        System.setProperty("propFile", "myproperties.properties");
        context.addComponent("properties", (Component)new PropertiesComponent("classpath:org/apache/camel/component/properties/${propFile}"));
        return context;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("propFile");
    }
}

