/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;

public class PropertiesEnvironmentVariableOverrideTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPropertiesComponentCacheDisabled() throws Exception {
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        pc.setCache(false);
        System.setProperty("cool.end", "mock:override");
        System.setProperty("cool.result", "override");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:cool.end");
                this.from("direct:foo").to("properties:mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:override").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        System.clearProperty("cool.end");
        System.clearProperty("cool.result");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setCamelContext(context);
        pc.setLocations(new String[]{"classpath:org/apache/camel/component/properties/myproperties.properties"});
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

