/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class DirectRequestReplyAndSedaInOnlyTest
extends ContextTestSupport {
    public void testInOut() throws Exception {
        this.getMockEndpoint("mock:log").expectedBodiesReceived(new Object[]{"Logging: Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        DirectRequestReplyAndSedaInOnlyTest.assertEquals((String)"Bye World", (String)out);
        this.log.info("Got reply " + out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.constant("Bye World"))).inOnly("seda:log");
                ((ExpressionNode)this.from("seda:log").delay(1000L).transform((Expression)this.body().prepend((Object)"Logging: "))).to(new String[]{"log:log", "mock:log"});
            }
        };
    }
}

