/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;

public class SedaBlockWhenFullTest
extends ContextTestSupport {
    private static final int QUEUE_SIZE = 1;
    private static final int DELAY = 10;
    private static final String MOCK_URI = "mock:blockWhenFullOutput";
    private static final String SIZE_PARAM = "?size=%d";
    private static final String BLOCK_WHEN_FULL_URI = "seda:blockingFoo" + String.format("?size=%d", 1) + "&blockWhenFull=true";
    private static final String DEFAULT_URI = "seda:foo" + String.format("?size=%d", 1);

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(BLOCK_WHEN_FULL_URI).delay(10L).to(SedaBlockWhenFullTest.MOCK_URI);
                this.from(DEFAULT_URI).delay(10L).to("mock:whatever");
            }
        };
    }

    public void testSedaDefaultWhenFull() throws Exception {
        try {
            SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(DEFAULT_URI, SedaEndpoint.class);
            SedaBlockWhenFullTest.assertFalse((String)"Seda Endpoint is not setting the correct default (should be false) for \"blockWhenFull\"", (boolean)seda.isBlockWhenFull());
            this.sendTwoOverCapacity(DEFAULT_URI, 1);
            SedaBlockWhenFullTest.fail((String)"The route didn't fill the queue beyond capacity: test class isn't working as intended");
        }
        catch (Exception e) {
            SedaBlockWhenFullTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
        }
    }

    public void testSedaBlockingWhenFull() throws Exception {
        this.getMockEndpoint(MOCK_URI).setExpectedMessageCount(3);
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(BLOCK_WHEN_FULL_URI, SedaEndpoint.class);
        SedaBlockWhenFullTest.assertEquals((int)1, (int)seda.getQueue().remainingCapacity());
        this.sendTwoOverCapacity(BLOCK_WHEN_FULL_URI, 1);
        this.assertMockEndpointsSatisfied();
    }

    private void sendTwoOverCapacity(String uri, int capacity) {
        for (int i = 0; i < capacity + 2; ++i) {
            this.template.sendBody(uri, (Object)("Message " + i));
        }
    }
}

