/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.seda.SedaEndpoint;

public class SedaDefaultUnboundedQueueSizeTest
extends ContextTestSupport {
    public void testSedaDefaultUnboundedQueueSize() throws Exception {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class);
        SedaDefaultUnboundedQueueSizeTest.assertEquals((int)0, (int)seda.getQueue().size());
        for (int i = 0; i < 1200; ++i) {
            this.template.sendBody("seda:foo", (Object)("Message " + i));
        }
        SedaDefaultUnboundedQueueSizeTest.assertEquals((int)1200, (int)seda.getQueue().size());
    }

    public void testSedaDefaultBoundedQueueSize() throws Exception {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda:foo?size=500", SedaEndpoint.class);
        SedaDefaultUnboundedQueueSizeTest.assertEquals((int)0, (int)seda.getQueue().size());
        for (int i = 0; i < 500; ++i) {
            this.template.sendBody("seda:foo", (Object)("Message " + i));
        }
        SedaDefaultUnboundedQueueSizeTest.assertEquals((int)500, (int)seda.getQueue().size());
        try {
            this.template.sendBody("seda:foo", (Object)"Message overflow");
            SedaDefaultUnboundedQueueSizeTest.fail((String)"Should thrown an exception");
        }
        catch (Exception e) {
            SedaDefaultUnboundedQueueSizeTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
        }
    }
}

