/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.ArrayBlockingQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class SedaQueueTest
extends ContextTestSupport {
    public void testQueue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Goodday World", "Bar"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:foo?size=20", (Object)"Bye World");
        this.template.sendBody("seda:foo?concurrentConsumers=5", (Object)"Goodday World");
        this.template.sendBody("seda:bar", (Object)"Bar");
    }

    public void testQueueRef() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:array?queue=#arrayQueue", (Object)"Hello World");
        SedaEndpoint sedaEndpoint = this.resolveMandatoryEndpoint("seda:array?queue=#arrayQueue", SedaEndpoint.class);
        SedaQueueTest.assertTrue((boolean)(sedaEndpoint.getQueue() instanceof ArrayBlockingQueue));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry simpleRegistry = new SimpleRegistry();
        simpleRegistry.put((Object)"arrayQueue", new ArrayBlockingQueue(10));
        return new DefaultCamelContext((Registry)simpleRegistry);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?size=20&concurrentConsumers=2").to("mock:result");
                this.from("seda:bar").to("mock:result");
                this.from("seda:array?queue=#arrayQueue").to("mock:result");
            }
        };
    }
}

