/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class SedaWaitForTaskNewerOnCompletionTest
extends ContextTestSupport {
    private static String done = "";
    private final CountDownLatch latch = new CountDownLatch(1);

    public void testNever() throws Exception {
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        SedaWaitForTaskNewerOnCompletionTest.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
        SedaWaitForTaskNewerOnCompletionTest.assertEquals((String)"BCA", (String)done);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(3).redeliveryDelay(0L));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                done = done + "A";
                                SedaWaitForTaskNewerOnCompletionTest.this.latch.countDown();
                            }
                        });
                    }
                })).to("seda:foo?waitForTaskToComplete=Never")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        done = done + "B";
                    }
                })).to("mock:result");
                ((ExpressionNode)this.from("seda:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).delay(1000L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        done = done + "C";
                    }
                })).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

