/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class TimerComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        TimerComponent comp = (TimerComponent)this.context.getComponent("timer", TimerComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("timer:foo?period=2000");
        TimerComponentConfigurationAndDocumentationTest.assertEquals((Object)"2000", (Object)conf.getParameter("period"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        TimerComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        TimerComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"timerName\": { \"type\": \"java.lang.String\" }"));
        TimerComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"delay\": { \"type\": \"long\" }"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        if (TimerComponentConfigurationAndDocumentationTest.isJavaVersion("1.6")) {
            return;
        }
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("timer");
        TimerComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML if on Java 7", (Object)html);
    }
}

