/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ValidatorIllegalImportTest
extends ContextTestSupport {
    private final String broadCastEvent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><BroadcastMonitor> <updated>2012-03-01T03:46:26</updated><stationName>P7 Mix</stationName><Current><startTime>2012-03-01T03:46:26</startTime><itemId>1000736343:8505553</itemId><titleId>785173</titleId><itemCode>9004342-0101</itemCode><itemReference></itemReference><titleName>Part Of Me</titleName><artistName>Katy Perry</artistName><albumName></albumName></Current><Next><startTime>2012-03-01T03:50:00</startTime><itemId>1000736343:8505554</itemId><titleId>780319</titleId><itemCode>2318050-0101</itemCode><itemReference></itemReference><titleName>Fine</titleName><artistName>Whitney Houston</artistName><albumName></albumName></Next></BroadcastMonitor>";

    public void testOk() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:test").to("validator:org/apache/camel/component/validator/BroadcastMonitorFixed.xsd")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:test", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><BroadcastMonitor> <updated>2012-03-01T03:46:26</updated><stationName>P7 Mix</stationName><Current><startTime>2012-03-01T03:46:26</startTime><itemId>1000736343:8505553</itemId><titleId>785173</titleId><itemCode>9004342-0101</itemCode><itemReference></itemReference><titleName>Part Of Me</titleName><artistName>Katy Perry</artistName><albumName></albumName></Current><Next><startTime>2012-03-01T03:50:00</startTime><itemId>1000736343:8505554</itemId><titleId>780319</titleId><itemCode>2318050-0101</itemCode><itemReference></itemReference><titleName>Fine</titleName><artistName>Whitney Houston</artistName><albumName></albumName></Next></BroadcastMonitor>");
        this.assertMockEndpointsSatisfied();
    }

    public void testIllegalImport() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:test").to("validator:org/apache/camel/component/validator/BroadcastMonitor.xsd")).to("mock:result");
            }
        });
        try {
            this.context.start();
            ValidatorIllegalImportTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = ValidatorIllegalImportTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            IllegalArgumentException iae = ValidatorIllegalImportTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
            ValidatorIllegalImportTest.assertTrue((boolean)iae.getMessage().startsWith("Resource: org/apache/camel/component/validator/BroadcastMonitor.xsd refers an invalid resource without SystemId."));
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

